<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Broadcast;
use App\Models\BroadcastContact;
use App\Models\Template;
use App\Models\whatsappAccount;
use App\Models\BroadcastLog;
use App\Models\Message;
use App\Models\Contacts;
use Carbon\Carbon;

class ProcessBroadcasts extends Command
{
    protected $signature = 'broadcast:process';
    protected $description = 'Process pending broadcasts';

    public function handle()
    {
        $now = Carbon::now();

        $nonScheduleBroadcasts = Broadcast::where('type', 'non-schedule')->where('status', 'pending')->get();

        foreach ($nonScheduleBroadcasts as $broadcast) {
            $this->sendBroadcast($broadcast);
        }

        $scheduledBroadcasts = Broadcast::where('status', 'pending')
            ->where('type', 'schedule')
            ->whereRaw("TIMESTAMP(schedule_date, schedule_time) <= NOW()")
            ->get();


        foreach ($scheduledBroadcasts as $broadcast) {

            $scheduledDateTime = Carbon::parse($broadcast->schedule_date . ' ' . $broadcast->schedule_time);

            if ($now->greaterThanOrEqualTo($scheduledDateTime)) {
                $this->sendBroadcast($broadcast);
            }
        }

        return 0;
    }


    private function sendBroadcast($broadcast)
    {
        $contacts = BroadcastContact::where('br_id', $broadcast->br_id)->get();

        foreach ($contacts as $contact) {


            $template = Template::where('template_id', $broadcast->template_id)->first();
            $mobile = Contacts::where('contact_id', $contact->contact_id)->first();
            $whatsapp = whatsappAccount::where('company_id', $broadcast->company_id)->first();

            // $data = [
            $api_key = $whatsapp->access_token;
            $mobile_no = $mobile->mobile_no;
            $template_name = $template->template_name;
            $sender_id = $whatsapp->phone_number_id;
            $type = $template->category;
            $file = $template->title_file ?? '';
            $filename = $broadcast->filename ?? '';
            $code = $whatsapp->language ?? 'en_US';
            $parameter = json_decode($template->parameters, true);
            // ];

            // $response = $data;
            $response = sendWhatsappTemplate($api_key, $mobile_no, $template_name, $sender_id, $type, $file, $filename, $code, $parameter);


            $message = Message::create([
                'company_id' => $broadcast->company_id,
                'contact_id' => $contact->contact_id,
                'type' => 'broadcast',
                'broadcast_id' => $broadcast->br_id,
                'message' => '',
                'direction' => 'out',
                'user_id' => $broadcast->user_id,
                'message_status' => 'Sent',
                'read_status' => 'Sent',
                'wa_id' => $response['body']['messages'][0]['id'] ?? null,
                'media_id' => '0',
                'created_date_time' => now(),
                'updated_date_time' => now(),
                'status' => 'Active'
            ]);

            BroadcastLog::create([
                'br_id'         => $broadcast->br_id,
                'mobile_no'     => $mobile->mobile_no,
                'request_json'  => json_encode($message),
                'response_json' =>  json_encode($response),
                'status'        => $response['messages'][0]['id'] ?? 'failed'
            ]);




            $contact->update(['status' => 'sent']);
        }

        $broadcast->update(['status' => 'completed']);
    }
}
