<?php

use Illuminate\Support\Facades\Http;

if (!function_exists('sendWhatsappTemplate')) {

    function sendWhatsappTemplate($accessToken,$mobile,$templateName,$senderId,$type,$file,$filename,$code,$parameter)
    {
        // $accessToken  = $data['api_key'] ?? null;
        // $mobile       = $data['mobile_no'] ?? null;
        // $templateName = $data['template_name'] ?? null;
        // $senderId     = $data['sender_id'] ?? null;
        // $type         = $data['type'] ?? null;
        // $file         = $data['file'] ?? null;
        // $filename     = $data['filename'] ?? null;
        // $code         = $data['code'] ?? 'en_US';
        // $parameter    = $data['parameter'] ?? [];

        // Add +91 if only 10 digits
        if (strlen($mobile) == 10) {
            $mobile = '91' . $mobile;
        }

        $messageUrl = "https://graph.facebook.com/v21.0/$senderId/messages";


        /**
         * -----------------------------
         * MEDIA UPLOAD HELPER (INNER)
         * -----------------------------
         */
        $uploadMedia = function ($filePath, $mime) use ($accessToken, $senderId) {

            $allowed = ['image/jpeg', 'image/png', 'application/pdf'];

            if (!in_array($mime, $allowed)) {
                return null;
            }

            $uploadUrl = "https://graph.facebook.com/v21.0/$senderId/media";

            $response = Http::withoutVerifying()
                ->withHeaders([
                    'Authorization' => "Bearer $accessToken"
                ])
                ->attach('file', file_get_contents($filePath), basename($filePath))
                ->post($uploadUrl, [
                    'messaging_product' => 'whatsapp'
                ]);

            return $response->json()['id'] ?? null;
        };


        /**
         * -----------------------------
         * TEMPLATE BASE JSON
         * -----------------------------
         */
        $templateData = [
            'messaging_product' => 'whatsapp',
            'to' => $mobile,
            'type' => 'template',
            'template' => [
                'name' => $templateName,
                'language' => ['code' => $code],
                'components' => []
            ]
        ];


        /**
         * -----------------------------
         * FILE HANDLING
         * -----------------------------
         */
        if ($file && ($type == 'Marketing' || $type == 'Utility')) {

            if (str_contains($file, 'http')) {

                $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));

                $mediaType = in_array($ext, ['jpeg', 'jpg', 'png']) ? 'image' : 'document';

                $fileComponent = [
                    'type' => 'header',
                    'parameters' => [
                        [
                            'type' => $mediaType,
                            $mediaType => [
                                'link' => $file
                            ]
                        ]
                    ]
                ];
            } else {

                $mime = mime_content_type($file);

                $mediaId = $uploadMedia($file, $mime);

                $mediaType = str_contains($mime, 'image') ? 'image' : 'document';

                $fileComponent = [
                    'type' => 'header',
                    'parameters' => [
                        [
                            'type' => $mediaType,
                            $mediaType => [
                                'id' => $mediaId
                            ]
                        ]
                    ]
                ];
            }

            $templateData['template']['components'][] = $fileComponent;
        }


        /**
         * -----------------------------
         * BODY PARAMETERS
         * -----------------------------
         */
        if (!empty($parameter)) {
            $templateData['template']['components'][] = [
                'type' => 'body',
                'parameters' => array_map(function ($value) {
                    return ['type' => 'text', 'text' => $value];
                }, $parameter)
            ];
        }


        /**
         * -----------------------------
         * OTP TEMPLATE
         * -----------------------------
         */
        if ($type == 'authentication') {

            $otp = rand(100000, 999999);

            $templateData['template']['components'] = [
                [
                    'type' => 'body',
                    'parameters' => [
                        ['type' => 'text', 'text' => $otp]
                    ]
                ],
                [
                    'type' => 'button',
                    'sub_type' => 'url',
                    'index' => 0,
                    'parameters' => [
                        ['type' => 'text', 'text' => $otp]
                    ]
                ]
            ];
        }


        /**
         * -----------------------------
         * FINAL API REQUEST
         * -----------------------------
         */
        $response = Http::withoutVerifying()
            ->withHeaders([
                'Authorization' => "Bearer $accessToken",
                'Content-Type' => 'application/json'
            ])
            ->post($messageUrl, $templateData);

            return [
                'success' => $response->successful(),
                'status'  => $response->status(),
                'body'    => $response->json() ?? $response->body(),
                'request' => $templateData
            ];
            
    }
}
