<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\whatsappAccount;
use App\Models\User;
use Illuminate\Http\Request;

class CompanyController extends Controller
{
    // public function index()
    // {
    //     return Company::with('whatsapp_account')->get();
    // }

    public function store(Request $request)
    {
        $companyData = $request->validate([
            'company_name' => 'required|string',
            'email_id' => 'required|email',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'address' => 'nullable|string',
            'country_code' => 'nullable|string',
            'mobile_no' => 'nullable|string',
            'user_id' => 'nullable|exists:users,id',
        ]);

        if ($request->hasFile('logo')) {
            $path = $request->file('logo')->store('logos', 'public');
            $companyData['logo'] = $path;
        }

        $company = Company::create($companyData);

        if (!empty($companyData['user_id'])) {
            $user = User::find($companyData['user_id']);
            if ($user) {
                $user->company_id = $company->company_id;
                $user->save();
            }
        }

        $whatsappData = $request->validate([
            'phone_number' => 'required|string',
            'phone_number_id' => 'required|string',
            'business_ac_id' => 'required|string',
            'app_id' => 'required|string',
            'access_token' => 'required|string',
        ]);

        $whatsappData['company_id'] = $company->company_id;

        $whatsappAccount = whatsappAccount::create($whatsappData);

        return response()->json([
            'company' => $company,
            'whatsapp_account' => $whatsappAccount
        ], 201);
    }


    public function show($id)
    {
        $company = Company::with('whatsappAccount')
           ->where('company_id', $id)
            ->first();

        if (!$company) {
            return response()->json(['message' => 'Company not found'], 404);
        }

        return $company;
    }



    public function update(Request $request, $id)
    {

    
        $company = Company::findOrFail($id);
        
        // Validate company fields
        $companyData = $request->validate([
            'company_name' => 'required',
            'email_id' => 'required|email',
            'address' => 'nullable',
            'country_code' => 'nullable',
            'mobile_no' => 'nullable',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048'
        ]);
       
    
        // Handle logo update
        if ($request->hasFile('logo')) {
            $path = $request->file('logo')->store('logos', 'public');
            $companyData['logo'] = $path;
        }
    
        // Update company
        $company->update($companyData);
    
        // Validate WhatsApp fields
        $whatsappData = $request->validate([
            'phone_number' => 'required|string',
            'phone_number_id' => 'required|string',
            'business_ac_id' => 'required|string',
            'app_id' => 'required|string',
            'access_token' => 'required|string',
        ]);
    
        // Update or create WhatsApp account
        $whatsappAccount = whatsappAccount::updateOrCreate(
            ['company_id' => $company->company_id],
            $whatsappData
        );
        return response()->json([
            'company' => $company,
            'whatsapp_account' => $whatsappAccount
        ], 200);
    }
    
    
    

    public function destroy($id)
    {
        $company = Company::findOrFail($id);
        $company->delete();
        return response()->json(['message' => 'Company deleted']);
    }
}
