<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Contacts;
use Illuminate\Support\Facades\Auth;
use Validator;
use Tymon\JWTAuth\Facades\JWTAuth;
use App\Http\Requests\ImportContactRequest;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ContactsImport;

class ContactController extends Controller
{


    public function store(Request $request)
    {
        $companyId = auth('api')->user()->company_id;

        $request->validate([
            'contact_name' => 'required',
            'mobile_no' => 'required',
            'profile' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $input = $request->all();

        if ($image = $request->file('profile')) {
            $destinationPath = base_path("../file_storage/contacts/");
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['profile'] = "$profileImage";
        }
        $input['company_id'] = $companyId;

        Contacts::create($input);
    }

    public function show()
    {
        $companyId = auth('api')->user()->company_id;
        $contacts = Contacts::where('company_id', $companyId)->where('status','Active')->get();


        return response()->json($contacts);
    }
    public function import(ImportContactRequest $request)
    {
        $file = $request->file('file');
        $groupName = $request->input('group_name');
        $companyId = auth('api')->user()->company_id;

        try {
            Excel::import(new ContactsImport($groupName, $companyId), $file);

            return response()->json([
                'success' => true,
                'message' => 'Contacts imported successfully'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error importing contacts: ' . $e->getMessage()
            ], 500);
        }
    }
    public function update(Request $request, $id)
    {
        $companyId = auth('api')->user()->company_id;
        $contact = Contacts::where('contact_id', $id)
            ->where('company_id', $companyId)
            ->first();

        if (!$contact) {
            return response()->json(['error' => 'Contact not found'], 404);
        }

        $validated = $request->validate([
            'contact_name' => 'sometimes|required|string|max:255',
            'mobile_no'    => 'sometimes|required|string|max:20',
            'group_name'    => 'nullable|required|string|max:20',
            'profile'      => 'nullable',
        ]);

        if ($request->hasFile('profile')) {
            $image = $request->file('profile');
            $destinationPath = base_path("../file_storage/contacts/");
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $validated['profile'] = $profileImage;
        }
        elseif ($request->filled('profile')) {
            $validated['profile'] = basename($request->profile);
        }

        $contact->update($validated);        
        return response()->json([
            'success' => true,
            'message' => 'Contact updated successfully',
            'contact' => $contact
        ]);
    }
}
