<?php

namespace App\Http\Controllers;

use App\Models\Template;
use App\Models\Buttons;
use App\Models\User;
use App\Models\Company;
use App\Models\whatsappAccount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class TemplateController extends Controller
{
    public function index()
    {
        $templates = Template::where('status','Active')->get();
        return response()->json($templates);
    }

    public function store(Request $request)
    {
        $request->validate([
            'template_name' => 'required|string|max:255',
            'language' => 'required|string|max:255',
            'category' => 'required',
            'title_type' => 'nullable|string',
            'buttons' => 'in:none,call_to_action,quick_reply',
            'type' => 'nullable|array',
            'type.*' => 'nullable|string|in:call_to_action,quick_reply',
            'text' => 'nullable|array',
            'text.*' => 'nullable|string',
            'call_to_action' => 'nullable|array',
            'call_to_action.*' => 'nullable|string|in:visit site,call phone',
            'cat' => 'nullable|array',
            'cat.*' => 'nullable|string',
            'company_id' => 'required',
            'body' => 'required|string',
            'footer' => 'nullable|string',
            'visit_website_url' => 'required_if:call_to_action_type,Visit Website|nullable|url',
            'call_phone_no' => 'required_if:call_to_action_type,Call Phone|nullable|string',
            'variables' => 'nullable',
            // 'user_id' => 'nullable',
            'title' => 'string|max:2048',
            'header_variables' => 'nullable',
            'title_file' => 'file|mimes:pdf,jpg,jpeg,png|max:2048',
            'quick_reply_messages' => 'nullable'
        ]);
        $variables = json_decode($request->input('variables', '[]'), true);
        $header_variables = json_decode($request->input('header_variables', '[]'), true);
        $companyId = auth('api')->user()->company_id;
        $user_id = auth('api')->user()->id;

        // if ($image = $request->file('title_file')) {
        //     $destinationPath = base_path("../file_storage/templates/");
        //     $title_fileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
        //     $image->move($destinationPath, $title_fileImage);
        //     $titleFileName = $title_fileImage;
        // $titleFileName = $request->file('title_file');
        // } else {
        //     $titleFileName = null; 
        // }
        $mime = $request->file('title_file')->getMimeType();
        $size = $request->file('title_file')->getSize();
        if (str_contains($mime, 'image')) $mediaType = 'image';
        elseif (str_contains($mime, 'video')) $mediaType = 'video';
        elseif (str_contains($mime, 'audio')) $mediaType = 'audio';
        else $mediaType = 'document';

        $image = $request->file('title_file');
        $destinationPath = base_path("..\\file_storage\\template\\");
        $tempName = uniqid('temp_') . "." . $image->getClientOriginalExtension();
        $tempPath = $destinationPath . $tempName;
        $image->move($destinationPath, $tempName);
        // var_dump($tempPath);
        // exit;
        $template = Template::create([
            'company_id' => $companyId,
            'template_name' => $request->input('template_name'),
            'category' => $request->input('category'),
            'language' => $request->input('language'),
            'title_type' => $request->input('title_type'),
            'title_text' => $request->input('title'),
            'header_variables' =>  $header_variables[0] ?? null,
            'title_file' => $tempName,
            'body' => $request->input('body'),
            'footer' => $request->input('footer'),
            'buttons' => 'none',
            'variable1' => $variables[0] ?? null,
            'variable2' => $variables[1] ?? null,
            'variable3' => $variables[2] ?? null,
            'variable4' => $variables[3] ?? null,
            'variable5' => $variables[4] ?? null,
            'variable6' => $variables[5] ?? null,
            'variable7' => $variables[6] ?? null,
            'variable8' => $variables[7] ?? null,
            'variable9' => $variables[8] ?? null,
            'variable10' => $variables[9] ?? null,
            'wa_approval_status' => $request->input('wa_approval_status'),
            'user_id' => $user_id,
            'status' => $request->input('status'),
        ]);
        $type = $request->input('type', []);
        $text = $request->input('text', []);
        $cat = $request->input('cat', []);

        $count = max(count($type), count($text), count($cat));
        for ($i = 0; $i < $count; $i++) {
            Buttons::create([
                'template_id' => $template->template_id,
                'types' => $type[$i] ?? null,
                'text' => $text[$i] ?? null,
                'values' => $cat[$i] ?? null,
                'call_phone_no' => $request->input('call_phone_no'),
            ]);
        }

        $components = [];


        $whatsappAccount = WhatsAppAccount::where('company_id', $companyId)->first();

        if ($request->title_type != 'none') {
            if ($request->title_type == 'text') {
                $headerComponent = [
                    'type' => 'HEADER',
                    'format' => 'TEXT',
                    'text' => $request->title,
                ];

                if ($request->has('header_variables') && !empty($request->header_variables)) {
                    $headerComponent['example'] = [
                        'header_text' => [
                            $header_variables[0]
                        ]
                    ];
                }

                $components[] = $headerComponent;
            } else {

                $file = $image;
                $filename = $file->getClientOriginalName();
                $fileSize = $size;

                if (str_starts_with($mime, 'image/')) {
                    $fileType = 'IMAGE';
                } elseif (str_starts_with($mime, 'video/')) {
                    $fileType = 'VIDEO';
                } elseif (in_array($mime, [
                    'application/pdf'
                ])) {
                    $fileType = 'DOCUMENT';
                } else {
                    $fileType = 'LOCATION';
                }

                $wabaId = $whatsappAccount->app_id;

                // 1️⃣ Create Upload Session
                $uploadResponse = Http::withHeaders([
                    'Authorization' => "Bearer {$whatsappAccount->access_token}",
                ])->withOptions([
                    'verify' => false,
                ])
                    ->post("https://graph.facebook.com/v24.0/{$wabaId}/uploads", [
                        'file_name'   => $filename,
                        'file_length' => $fileSize,
                        'file_type'   => $mime
                    ]);

                $attachmentId = $uploadResponse->json('id');

                if ($attachmentId) {
                    $message = Template::find($template->template_id);
                    $message->media_id = $attachmentId;
                    $message->save();
                }


                $headerHandleResponse = Http::withHeaders([
                    'Authorization' => "Bearer {$whatsappAccount->access_token}",
                ])
                    ->withOptions([
                        'verify' => false,
                    ])
                    ->attach('file', file_get_contents($tempPath), basename($tempPath))
                    ->post("https://graph.facebook.com/v24.0/{$attachmentId}&file_offset=0");

                $header = $headerHandleResponse->json('h');
                $components[] = [
                    'type' => 'HEADER',
                    'format' => 'image',
                    'example' => [
                        'header_handle' => [$header]
                    ]
                ];
            }
        }
        $component = [
            'type' => 'BODY',
            'text' => $request->body
        ];

        if (!empty($request->variables)) {
            $component['example'] = [
                'body_text' => [
                    $request->variables
                ]
            ];
        }
        $components[] = $component;
        if (!empty($request->footer)) {
            $components[] = [
                'type' => 'FOOTER',
                'text' => $request->footer
            ];
        }
        $types = $request->type ?? [];
        $texts = $request->text ?? [];
        $actions = $request->call_to_action ?? [];
        $cats = $request->cat ?? [];

        $buttons = [];
        if (!empty($types) && is_array($types)) {
            foreach ($types as $index => $type) {
                $text = $texts[$index] ?? '';
                $action = $actions[$index] ?? '';
                $cat = $cats[$index] ?? '';

                if ($type === 'call_to_action') {
                    if ($action === 'visit site') {
                        $buttons[] = [
                            'type' => 'URL',
                            'text' => $text,
                            'url' => $cat
                        ];
                    } elseif ($action === 'call phone') {
                        $buttons[] = [
                            'type' => 'PHONE_NUMBER',
                            'text' => $text,
                            'phone_number' => $cat
                        ];
                    }
                } else {
                    $buttons[] = [
                        'type' => 'QUICK_REPLY',
                        'text' => $text
                    ];
                }
            }
        }

        if (!empty($buttons)) {
            $components[] = [
                'type' => 'BUTTONS',
                'buttons' => $buttons
            ];
        }

        try {
            $response = Http::withHeaders([
                'Authorization' => "Bearer {$whatsappAccount->access_token}",
                'Content-Type' => 'application/json',
            ])
                ->withOptions([
                    'verify' => false,
                ])->post("https://graph.facebook.com/v21.0/{$whatsappAccount->business_ac_id}/message_templates", [
                    'name' => $this->formatTemplateName($request->template_name),
                    'language' => $request->language,
                    'category' => $request->category,
                    'components' => $components,
                ]);

            if ($response->failed()) {
                \Log::error('WhatsApp template creation failed', [
                    'response' => $response->json(),
                    'request' => $request->all()
                ]);

                $template->delete();

                return response()->json([
                    'success' => false,
                    'message' => 'WhatsApp template creation failed',
                    'error' => $response->json()
                ], 400);
            }

            $template->update(['whatsapp_template_id' => $response->json('id')]);

            return response()->json([
                'success' => true,
                'template' => $template,
                'whatsapp_response' => $response->json(),
            ], 201);
            exit;
        } catch (\Exception $e) {
            \Log::error('WhatsApp template creation exception', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);

            return response()->json([
                'success' => false,
                'message' => 'An error occurred while creating the template',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Format template name to meet WhatsApp requirements
     */
    private function formatTemplateName($name)
    {
        $name = strtolower($name);
        $name = str_replace(' ', '_', $name);
        $name = preg_replace('/[^a-z0-9_]/', '', $name);
        return substr($name, 0, 100);
    }

    public function show()
    {
        $companyId = auth('api')->user()->company_id;

        $templates = Template::with('buttons')
            ->where('company_id', $companyId)
            ->get();

        return response()->json([
            'templates' => $templates,
        ], 200);
    }
    public function delete($id)
    {
        try {
            $companyId = auth('api')->user()->company_id;
            $template = Template::where('template_id', $id)
                ->where('company_id', $companyId)
                ->firstOrFail();

            $template->status = 'Inactive';
            $template->save();

            return response()->json([
                'success' => true,
                'message' => 'Template marked as inactive',
                'template' => $template,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to update template status',
                'error' => $e->getMessage(),
            ], 500);
        }
    }

    public function view($id)
    {
        // $companyId = auth('api')->user()->company_id;

        $templates = Template::with('buttons')
            // ->where('company_id', $companyId)
            ->where('template_id', $id)
            ->get();

        return response()->json([
            'templates' => $templates,
        ], 200);
    }

    public function update(Request $request, $id)
    {
        $template = Template::findOrFail($id);

        $request->validate([
            'template_name' => 'sometimes|required|string|max:255|unique:templates,template_name,' . $id,
            'language' => 'sometimes|required|string|max:255',
            'category' => 'sometimes|required|in:MARKETING,TRANSACTIONAL,OTP',
            'title_type' => 'nullable|string',
            'buttons' => 'sometimes|required|in:none,call_to_action,quick_reply',
            'call_to_action_type' => 'sometimes|required_if:buttons,call_to_action|in:none,Call Phone,Visit Website',
            'body' => 'sometimes|required|string',
            'footer' => 'nullable|string',
            'visit_website_url' => 'sometimes|required_if:call_to_action_type,Visit Website|nullable|url',
            'call_phone_no' => 'sometimes|required_if:call_to_action_type,Call Phone|nullable|string',
        ]);

        $template->update($request->all());
        return response()->json($template);
    }

    public function destroy($id)
    {
        $template = Template::findOrFail($id);
        $template->delete();
        return response()->json(['message' => 'Template deleted successfully']);
    }
}
