<?php

namespace App\Http\Controllers;

use App\Models\Template;
use App\Models\Buttons;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Models\whatsappAccount;
use Illuminate\Support\Facades\Http;

class TemplatesnycController extends Controller
{
    public function store(Request $request, $id)
    {
        DB::beginTransaction();

        $whatsapp = whatsappAccount::where('company_id', $id)->first();

        if (!$whatsapp) {
            return response()->json(['error' => 'WhatsApp account not found'], 404);
        }
        // var_dump($whatsapp);

        $response = Http::withOptions(['verify' => false])
            ->get("https://graph.facebook.com/v23.0/{$whatsapp->business_ac_id}/message_templates", [
                'access_token' => $whatsapp->access_token
                // 'access_token' => 'EAASUKrDGufcBP4UmWPFH8thoamh0ZBqqYFZApHEfIBnzoAzr2g5U9MrVoqvYFTm0g7hSeaYZCWqPK5cUZAAlFr623YURzXdmIDdatX2Vt7YuHjiY8cQ5kori0kp45m051vSDKw1E48q44uQLDFvuuMpZAadS9GyslufbnwNGoGYIPKe3niZCcfUg0wsshbnuwRhwZDZD'
            ]);

        $responseData = $response->json();  // <-- this is your templates data
        // var_dump($responseData);
        try {
            // $responseData = $request->all();

            foreach ($responseData['data'] as $templateData) {

                $existing = Template::where('meta_id', $templateData['id'])
                    ->where('company_id', $id)
                    ->first();

                if (!$existing) {
                    $template = Template::create([
                        'company_id' => $id,
                        'template_name' => $templateData['name'],
                        'category' => $templateData['category'],
                        'language' => $templateData['language'],
                        'wa_approval_status' => $templateData['status'],
                        'meta_id' => $templateData['id'],
                        'parameter_format' => $templateData['parameter_format'] ?? null,
                        'sub_category' => $templateData['sub_category'] ?? null,
                        'status' => 'Active',
                    ]);

                    // Process components
                    if (isset($templateData['components'])) {

                        $this->processComponents($template->template_id, $templateData['components']);
                    }
                }
            }

            DB::commit();

            return response()->json([
                'message' => 'Templates and buttons inserted successfully!',
                'count' => count($responseData['data'])
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Template import failed: ' . $e->getMessage());

            return response()->json([
                'error' => 'Failed to import templates',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    private function processComponents($templateId, $components)
    {
        $body = null;
        $footer = null;
        $headerFilePath = null;
        $fileName = null;
        $title_type = "none";

        foreach ($components as $component) {

            if ($component['type'] === "HEADER" && isset($component['format'])  && isset($component['example']['header_handle'][0])) {
                $url = $component['example']['header_handle'][0];

                $destinationPath = base_path("../file_storage/template/");
                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0755, true);
                }
                $extension = pathinfo(parse_url($url, PHP_URL_PATH), PATHINFO_EXTENSION);

                // If API gives no extension, fallback based on format
                if (!$extension) {
                    if ($component['format'] === "DOCUMENT") {
                        $extension = "pdf";
                        $title_type = 'document';
                    }
                    if ($component['format'] === "IMAGE") {
                        $title_type = 'image';
                        $extension = "jpg";
                    }
                    if ($component['format'] === "VIDEO") {
                        $extension = "mp4";
                        $title_type = 'video';
                    }
                } else {
                    if ($component['format'] === "DOCUMENT") {
                        $title_type = 'document';
                    }
                    if ($component['format'] === "IMAGE") {
                        $title_type = 'image';
                    }
                    if ($component['format'] === "VIDEO") {
                        $extension = "mp4";
                    }
                }

                // File Name
                $fileName = "template_" . $templateId . "_" . time() . "." . $extension;
                $fullPath = $destinationPath . $fileName;

                try {
                    $fileContent = file_get_contents($url);
                    if ($fileContent) {
                        file_put_contents($fullPath, $fileContent);
                    }
                } catch (\Exception $e) {
                    Log::error("File download failed: " . $e->getMessage());
                }
            }

            if ($component['type'] === "BODY") {
                $body = $component['text'] ?? null;

                $variables = $component['example']['body_text'][0] ?? [];

                $variableData = [];

                foreach ($variables as $i => $val) {

                    $column = 'variable' . ($i + 1);

                    $variableData[$column] = $val;
                }
                Template::where('template_id', $templateId)->update($variableData);
            }

            if ($component['type'] === "FOOTER") {
                $footer = $component['text'] ?? null;
            }


            if ($component['type'] === 'BUTTONS' && isset($component['buttons'])) {
                foreach ($component['buttons'] as $button) {
                    if ($button['type'] === 'PHONE_NUMBER') {
                        $value = $button['phone_number'];
                    } else if ($button['type'] === 'URL') {
                        $value = $button['url'];
                    } else {
                        $value = $button;
                    }

                    Buttons::create([
                        'template_id' => $templateId,
                        'types' => $button['type'],
                        'text' => $button['text'],
                        'values' => json_encode($value),
                    ]);
                }
            }
        }
        // var_dump($title_type);
        Template::where('template_id', $templateId)->update([
            'body'   => $body,
            'footer' => $footer,
            'title_file' => $fileName ?? null,
            'title_type' => $title_type ?? 'none',
        ]);
    }
}
