<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\ConfirmPassword;

class UserController extends Controller
{
    public function show($id)
    {
        $user = User::find($id);
        if (!$user) {
            return response()->json(['error' => 'User not found'], 404);
        }
        return response()->json($user);
    }
    public function alluser($id)
    {
        $users = User::where('company_id', $id)->get();
        if ($users->isEmpty()) {
            return response()->json(['error' => 'No users found'], 404);
        }

        return response()->json($users);
    }


    public function store(Request $request)
    {
        $companyId = auth('api')->user()->company_id;
    
        $validated = $request->validate([
            'name'  => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
            'role'  => 'required|string',
        ]);
        $otp = rand(1000, 9999);
    
        $user = User::create([
            'name'       => $validated['name'],
            'email'      => $validated['email'],
            'role'       => $validated['role'],
            'otp'       => $otp,
            'otp_status'       => 'Verified',
            'company_id' => $companyId
        ]);
    
        if (!$user) {
            return response()->json([
                'error' => 'User creation failed'
            ], 500);
        }
    
    
        // Mail::to($user->email)->send(
        //     new LoginOtpMail($otp, $user->name,$user->email, 'This is a test message.')
        // );
        Mail::to($user->email)->send(new ConfirmPassword($user->name, $otp, $validated['email']));

        return response()->json([
            'message' => 'User created successfully. OTP sent.',
            'user' => $user
        ], 201);
    }
    

    public function update(Request $request, $id)
    {
        $user = User::find($id);
        if (!$user) {
            return response()->json(['error' => 'User not found'], 404);
        }

        $validated = $request->validate([
            'name' => 'sometimes|required|string|max:255',
            'email' => 'sometimes|required|string|email|max:255|unique:users,email,' . $id,
            'password' => 'sometimes|required|string|min:8',
            'role' => 'sometimes|required|string',
            'company_id' => 'sometimes|required|string',
        ]);

        if (isset($validated['password'])) {
            $validated['password'] = Hash::make($validated['password']);
        }

        $user->update($validated);

        return response()->json($user);
    }

    public function destroy($id)
    {
        $user = User::find($id);
        if (!$user) {
            return response()->json(['error' => 'User not found'], 404);
        }

        $user->delete();

        return response()->json(['message' => 'User deleted successfully']);
    }
}
