<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use App\Mail\LoginOtpMail;
use App\Mail\ResendOtp;
use App\Mail\ResetPassword;
use App\Mail\SuccessLogin;
use App\Models\Company;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Facades\JWTAuth;

class AuthController extends Controller
{
    public function register(Request $request)
    {
        $user_checked = User::where('email', $request->email)
            ->where('otp_status', 'Verified')
            ->first();

        if ($user_checked) {
            return response()->json([
                'message' => 'The Email Id Is Already Registered',
                'status'  => 401
            ], 401);
        }else{
       
        $otp = rand(1000, 9999);
        $user = User::where('email', $request->email)->first();

        if (!$user) {
            $user = User::create([
                'name'      => $request->name,
                'email'     => $request->email,
                'password'  => Hash::make($request->password),
                'otp'       => $otp,
            ]);

            $company = Company::create([
                'user_id' => $user->id,
                'created_date_time' =>  NOW(),
                'updated_date_time' =>  NOW(),
                'status' => 'Active'
            ]);

            $user->update([
                'company_id' => $company->company_id,
            ]);

            Mail::to($user->email)->send(new LoginOtpMail($otp, $user->name,$user->email, 'This is a test message.'));

            return response()->json([
                'status'      => true,
                'userid'      => $user->id,
                'user'        => $user,
                'company'     => $company,
                'message'     => 'User Successfully Registered'
            ]);
        } else {
            $user->update([
                'name'      => $request->name,
                'password'  => Hash::make($request->password),
                'otp'       => $otp,
            ]);

            $company = Company::where('user_id', $user->id)->first();
            if ($company) {
                $company->update([
                    'company_name' => $request->name, 
                ]);
            }
            Mail::to($user->email)->send(new LoginOtpMail($otp, $user->name,$user->email, 'This is a test message.'));

            return response()->json([
                "success" => true,
                'user'    => $user,
                'company' => $company,
                'message' => 'User Successfully Updated'
            ]);
          }
        }

        
    }


public function login(Request $request)
{
    $request->validate([
        'email' => 'required|email',
        'password' => 'required|string|min:6',
    ]);

    $user_checked = User::where('email', $request->email)
        ->where('otp_status', 'Verified')
        ->first();

    if (!$user_checked) {
        return response()->json([
            'status' => false,
            'message' => 'Your email is not verified. Please verify before login.',
        ], 403);
    }

    $credentials = $request->only('email', 'password');

    if (!$token = JWTAuth::attempt($credentials)) {
        return response()->json([
            'status' => false,
            'message' => 'Invalid Email or Password'
        ], 401);
    }

    $user = Auth::user();

    $user->update([
        'jwt_token' => $token, 
    ]);

    return response()->json([
        'status' => true,
        'message' => 'Login successful',
        'token' => $token,
        'user' => $user
    ]);
}

    public function updatePassword(Request $request)
    {

        $id = $request->id;

        $User = User::find($id);
        $password_check = $request->oldpassword;

        if (Hash::check($password_check, $User->password)) {

            $User->update([
                'password'  => Hash::make($request->newpassword),
            ]);

            return response()->json([
                'message' => 'Your password is updated successfully. Next time when you log in, use this new password.',
                'status' => 200
            ]);
        } else {

            return response()->json([
                'message' => 'Your Old Password Is InCorrected',
                'status' => 404
            ]);
        }
    }



    public function Logout(Request $request)
    {
        $user = Auth::user();
    
        if ($user && $request->user()->currentAccessToken()) {
            $request->user()->currentAccessToken()->delete();
        }
    
        return response()->json([
            'message' => 'Logout successful'
        ]);
    }
    

    public function getUser(Request $request)
    {
        return "Hello World";
    }

    public function UserCheck(Request $request)
    {

        $user_cheked = User::where('email', $request->email)
            ->where('otp_status', 'Unverified')
            ->first();

        $otpSentTime = Carbon::parse($user_cheked->updated_at);

        if (now()->diffInRealSeconds($otpSentTime) > 600) {

            return response()->json([
                'message' => 'Your OTP has expired. Please request a new one.',
                'status' => 401
            ],401);
        }

        if ($user_cheked->otp === $request->otp) {

            $user_cheked->update([
                'otp_status' => 'Verified',
                'email_verified_at' => $otpSentTime,
            ]);

            Mail::to($user_cheked->email)->send(new SuccessLogin($user_cheked->name, 'This is a test message.'));

            return response()->json([
                'message' => 'Welcome to Skynyx Dev. Your registration has been successfully completed.',
                'success' => true
            ]);
        } else {

            return response()->json([
                'message' => 'The OTP you entered is incorrect. Please enter the correct four-digit OTP.',
                'status' => 401
            ], 401);
        }
    }

    public function resendotp(Request $request)
    {
        $user = User::where('email', $request->email)->first();
        $otp = rand(1000, 9999);

        if ($user) {
            $user->update([
                'otp'     => $otp,
            ]);
        }

        Mail::to($user->email)->send(new ResendOtp($user->name, $otp));

        return response()->json([
            'status' => 200,
            'message' => 'A new OTP has been sent successfully.',
        ],200);
    }

    public function ResetPassword(Request $request)
    {

        $user_cheked = User::where('email', $request->email)
            ->where('otp_status', 'Verified')
            ->first();

        if ($user_cheked) {

            $Resetotp = rand(1000, 9999);

            $user_cheked->update([
                'password_update' => $Resetotp,
            ]);

            Mail::to($user_cheked->email)->send(new ResetPassword($user_cheked->name, $Resetotp));

            return response()->json([
                'message' => 'The OTP for resetting your password has been successfully sent to your email. Please enter the four-digit OTP to proceed.',
                'status' => 200
            ]);
        } else {

            return response()->json([
                'message' => 'Please finish the registration First.',
                'status' => 401
            ],401);
        }
    }

    public function ResetPasswordOtpChecked(Request $request)
    {

        $user_cheked = User::where('email', $request->email)
            ->where('otp_status', 'Verified')
            ->first();

        $otpSentTime = Carbon::parse($user_cheked->updated_at);

        if (now()->diffInRealSeconds($otpSentTime) > 600) {

            return response()->json([
                'message' => 'The OTP has expired. Kindly request a new one to proceed.',
                'status' => 401
            ]);
        }

        if ($user_cheked->password_update === $request->otp) {

            return response()->json([
                'message' => 'Your reset password OTP has been successfully validated.',
                'status' => 200
            ]);
        } else {

            return response()->json([
                'message' => 'The four-digit OTP you entered is incorrect. Please try again.',
                'status' => 401
            ],401);
        }
    }

    public function updateuserpassword(Request $request)
    {

        $user_cheked = User::where('email', $request->email)->first();

        if ($user_cheked) {

            $user_cheked->update([
                'password'  => Hash::make($request->password),
            ]);

            return response()->json([
                'message' => 'Your password has been updated successfully. Use your new password to log in.',
                'status' => 200
            ]);
        } else {

            return response()->json([
                'message' => 'Something Went Wrong!.',
                'status' => 401
            ]);
        }
    }
}
