<?php
namespace App\Imports;

use App\Models\Contacts;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Carbon\Carbon;

class ContactsImport implements ToModel, WithHeadingRow
{
    protected $groupName;
    protected $companyId;

    public function __construct($groupName, $companyId)
    {
        $this->groupName = $groupName;
        $this->companyId = $companyId;
    }

    public function model(array $row)
    {
        return new Contacts([
            'contact_name' => $row['name'] ?? $row['Name'] ?? null,
            'mobile_no' => $row['number'] ?? $row['Number'] ?? $row['Phone'] ?? null,
            'group_name' => $this->groupName ?? $row['group_name'] ?? $row['Group'] ?? null,
            'profile' =>  $row['profile'] ?? $row['profile'] ?? $row['profile'] ?? "",
            'created_date_time' => $row['created_date_time'] ?? Carbon::now(),
            'company_id' => $this->companyId,
        ]);
    }

    public function rules(): array
    {
        return [
            'contact_name' => 'required|string',
            'mobile_no' => 'required|string',
        ];
    }
}