<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ConfirmPassword extends Mailable
{
    use Queueable, SerializesModels;

    public $otp;
    public $name;
    public $email;

    public function __construct($name, $otp, $email)
    {
        $this->name = $name;
        $this->otp = $otp;
        $this->email = $email;
    }

    public function build()
    {
        $encodedEmail = base64_encode($this->email);
        $loginUrl = "http://mercury.skynyxserver.com:3000/auth/set-otp-password?email=" . urlencode($encodedEmail);

        $htmlContent = '
    <html>
        <head>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    background-color: #f4f4f4;
                    margin: 0;
                    padding: 0;
                }
                .email-container {
                    max-width: 600px;
                    margin: 40px auto;
                    background-color: #ffffff;
                    border-radius: 8px;
                    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
                    padding: 40px 30px;
                    text-align: center;
                }
                h1 {
                    color: #007bff;
                    margin-bottom: 10px;
                }
                h2 {
                    color: #333;
                    margin-top: 0;
                }
                .otp-box {
                    font-size: 36px;
                    font-weight: bold;
                    color: #ffffff;
                    background-color: #007bff;
                    padding: 15px 30px;
                    border-radius: 8px;
                    display: inline-block;
                    margin: 25px 0;
                    letter-spacing: 6px;
                }
                p {
                    color: #555555;
                    font-size: 16px;
                    line-height: 1.6;
                    margin: 15px 0;
                }
                .login-btn {
                    display: inline-block;
                    margin-top: 20px;
                    padding: 12px 25px;
                    background-color: #007bff;
                    color: #ffffff;
                    text-decoration: none;
                    border-radius: 6px;
                    font-weight: bold;
                }
                .footer {
                    font-size: 12px;
                    color: #aaaaaa;
                    margin-top: 40px;
                }
            </style>
        </head>
        <body>
           <div class="email-container">
                <h1>Password set Request</h1>
                <h2>Hello, ' . htmlspecialchars($this->name) . '</h2>

                <p>You requested to set your password for your <strong>Skynyx Dev</strong> account.</p>
                <p>Please use the verification code below to continue setting your password.</p>


                <p>This verification code is valid for <strong>10 minutes</strong>.</p>

                <p>If you did not request a password set, please ignore this email.</p>

                <a class="login-btn" href="' . $loginUrl . '">set Password</a>

                <div class="footer">
                    <p>This is an automated message. Please do not reply.</p>
                </div>
            </div>
        </body>
    </html>
';

        return $this->subject('Password set Verification Code')
            ->html($htmlContent);
    }
}
