<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class LoginOtpMail extends Mailable
{
    use Queueable, SerializesModels;

    public $otp;
    public $name;
    public $message;
    public $email;

    public function __construct($otp, $name, $email, $message)
    {
        $this->otp = $otp;
        $this->name = $name;
        $this->message = $message;
        $this->email = $email;
    }

    public function build()
    {
        $encodedEmail = base64_encode($this->email);

        // Example link for email
        $loginUrl = "http://mercury.skynyxserver.com:3000/auth/set-otp?email=" . urlencode($encodedEmail);

        $htmlContent = '
        <html>
        <head>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    background-color: #f4f4f4;
                    margin: 0;
                    padding: 0;
                }
                .email-container {
                    max-width: 600px;
                    margin: 40px auto;
                    background-color: #ffffff;
                    border-radius: 8px;
                    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
                    padding: 40px 30px;
                    text-align: center;
                }
                h1 {
                    color: #007bff;
                }
                .otp-box {
                    font-size: 36px;
                    font-weight: bold;
                    color: #fff;
                    background-color: #007bff;
                    padding: 15px 30px;
                    border-radius: 8px;
                    display: inline-block;
                    margin: 25px 0;
                    letter-spacing: 6px;
                }
                .footer {
                    font-size: 12px;
                    color: #888;
                    margin-top: 40px;
                }
                .login-btn {
                    display: inline-block;
                    padding: 12px 25px;
                    background-color: #28a745;
                    color: #fff;
                    text-decoration: none;
                    border-radius: 6px;
                    font-weight: bold;
                    margin-top: 20px;
                }
            </style>
        </head>
        <body>
            <div class="email-container">
                <h1>Skynyx AI Verification</h1>
                <h2>Hello, ' . htmlspecialchars($this->name) . '</h2>

                <p>Your One-Time Password (OTP) is:</p>

                <div class="otp-box">' . htmlspecialchars($this->otp) . '</div>

                <p>This OTP is valid for <strong>10 minutes</strong>.</p>

                <p>If you want to continue logging in, click the button below:</p>

                <a class="login-btn" href="' . $loginUrl . '">Login to Skynyx AI</a>

                <div class="footer">
                    <p>This is an automated email, please do not reply.</p>
                </div>
            </div>
        </body>
    </html>';

        return $this->subject('Login OTP Mail')->html($htmlContent);
    }
}
