<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ResendOtp extends Mailable
{
    use Queueable, SerializesModels;

    public $name;
    public $otp;

    /**
     * Create a new message instance.
     *
     * @param string $name
     * @param string $message
     */
    public function __construct($name, $otp)
    {
        $this->name = $name;
        $this->otp = $otp;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $htmlContent = '
            <html>
                <head>
                    <style>
                        body {
                            font-family: Arial, sans-serif;
                            background-color: #f4f4f4;
                            margin: 0;
                            padding: 0;
                        }
                        .email-container {
                            max-width: 600px;
                            margin: 40px auto;
                            background-color: #ffffff;
                            border-radius: 8px;
                            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
                            padding: 40px 30px;
                            text-align: center;
                        }
                        h1 {
                            color: #007bff;
                            margin-bottom: 10px;
                        }
                        h2 {
                            color: #333;
                            margin-top: 0;
                        }
                        p {
                            color: #555555;
                            font-size: 16px;
                            line-height: 1.6;
                            margin: 15px 0;
                        }
                        .otp-code {
                            font-size: 24px;
                            font-weight: bold;
                            color: #007bff;
                            margin: 20px 0;
                        }
                        .footer {
                            font-size: 12px;
                            color: #aaaaaa;
                            margin-top: 40px;
                        }
                    </style>
                </head>
                <body>
                    <div class="email-container">
                        <h1>OTP Verification</h1>
                        <h2>Hello, ' . htmlspecialchars($this->name) . '</h2>
                        <p>This is your <strong>resent OTP</strong> for verification:</p>
                        <div class="otp-code">' . htmlspecialchars($this->otp) . '</div>
                        <p>This OTP is valid for 10 minutes. Please do not share it with anyone.</p>
                        <p>If you did not request this code, please ignore this message.</p>
                        <div class="footer">
                            <p>This is an automated message. Please do not reply.</p>
                        </div>
                    </div>
                </body>
            </html>';

        return $this->subject('Login OTP Mail')
            ->html($htmlContent);
    }
}
