<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ResetPassword extends Mailable
{
    use Queueable, SerializesModels;


    public $otp;
    public $name;
    public $message;

    /**
     * Create a new message instance.
     *
     * @param int|string $otp
     * @param string $name
     * @param string $message
     */

    public function __construct($name,$otp)
    {
        $this->name = $name;
        $this->otp = $otp;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $htmlContent = '
    <html>
        <head>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    background-color: #f4f4f4;
                    margin: 0;
                    padding: 0;
                }
                .email-container {
                    max-width: 600px;
                    margin: 40px auto;
                    background-color: #ffffff;
                    border-radius: 8px;
                    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
                    padding: 40px 30px;
                    text-align: center;
                }
                h1 {
                    color: #007bff;
                    margin-bottom: 10px;
                }
                h2 {
                    color: #333;
                    margin-top: 0;
                }
                .otp-box {
                    font-size: 36px;
                    font-weight: bold;
                    color: #ffffff;
                    background-color: #007bff;
                    padding: 15px 30px;
                    border-radius: 8px;
                    display: inline-block;
                    margin: 25px 0;
                    letter-spacing: 6px;
                }
                p {
                    color: #555555;
                    font-size: 16px;
                    line-height: 1.6;
                    margin: 15px 0;
                }
                .footer {
                    font-size: 12px;
                    color: #aaaaaa;
                    margin-top: 40px;
                }
            </style>
        </head>
        <body>
           <div class="email-container">
                <h1>Password Reset Request</h1>
                <h2>Hello, ' . htmlspecialchars($this->name) . '</h2>
                <p>We received a request to reset your password for your <strong>Skynyx Dev</strong> account. Use the verification code below to reset your password. This code is valid for <strong>10 minutes</strong>.</p>
                <div class="otp-box">' . htmlspecialchars($this->otp) . '</div>
                <p>If you did not request a password reset, please ignore this email or contact our support team.</p>
                <p>For security reasons, do not share this code with anyone.</p>
                <p>Thanks,<br><strong>Skynyx Dev Team</strong></p>
                <div class="footer">
                    <p>This is an automated message. Please do not reply.</p>
                </div>
            </div>
        </body>
    </html>
';
        return $this->subject('Reset Password Mail')
            ->html($htmlContent);
    }
}
