<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Broadcast extends Model
{
    protected $table = 'broadcasts';
    protected $primaryKey = 'br_id';
    public $timestamps = false; // using custom timestamps

    protected $fillable = [
        'broadcast_name',
        'template_id',
        'date',
        'type',
        'schedule_date',
        'schedule_time',
        'status',
        'user_id',
        'company_id',
        'created_date_time',
        'update_date_time'
    ];

    // Relationship: One Broadcast → Many Contacts
    public function contacts()
    {
        return $this->hasMany(BroadcastContact::class, 'br_id', 'br_id');
    }
}
