<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BroadcastContact extends Model
{
    protected $table = 'broadcast_contacts';
    protected $primaryKey = 'bc_id';
    public $timestamps = false;

    protected $fillable = [
        'br_id',
        'contact_id',
        'user_id',
        'company_id',
        'status'
    ];

    // Relationship: Many Contacts → One Broadcast
    public function broadcast()
    {
        return $this->belongsTo(Broadcast::class, 'br_id', 'br_id');
    }
}
