<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;

    protected $table = 'companies';
    protected $primaryKey = 'company_id';
    const CREATED_AT = 'created_date_time';
    const UPDATED_AT = 'updated_date_time';
    protected $fillable = [
        'company_id', 'company_name', 'email_id', 'logo', 'address',
        'country_code', 'mobile_no', 'created_date_time', 'updated_date_time', 	'status ', 'user_id', 'status'
    ];
    protected $casts = [
        'created_date_time' => 'datetime',
        'updated_date_time' => 'datetime',
    ];
    public function whatsappAccount()
    {
        return $this->hasOne(WhatsappAccount::class, 'company_id');
    }
    
}
