<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contacts extends Model
{
    use HasFactory;
    protected $primaryKey = 'contact_id';
    const CREATED_AT = 'created_date_time';
    const UPDATED_AT = 'updated_date_time';
    protected $fillable = [
        'contact_id',
        'company_id',
        'contact_name',
        'mobile_no',
        'group_name',
        'profile',
        'user_id',
        'created_date_time',
        'updated_date_time',
        'status'
    ];
    protected $casts = [
        'created_date_time' => 'datetime',
        'updated_date_time' => 'datetime',
    ];

    public function messages()
    {
        return $this->hasMany(Message::class, 'contact_id', 'contact_id');
    }

    public function lastMessage()
    {
        return $this->hasOne(Message::class, 'contact_id', 'contact_id')
            ->latest('created_date_time');
    }
}
