<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Events\MessageReceived;

class Message extends Model
{
    use HasFactory;

    protected $table = 'messages'; // adjust if different
    protected $primaryKey = 'message_id';
    public $timestamps = false;

    protected $fillable = [
        'company_id', 'contact_id', 'type', 'broadcast_id', 'message', 'direction','mime_type','contact_no','contact_number',
        'message_type', 'user_id', 'message_status','read_status', 'wa_id', 'media_id',
        'created_date_time', 'updated_date_time', 'status'
    ];

    protected static function boot()
    {
        parent::boot();

        static::created(function ($message) {
            // Fire only for incoming messages
            if ($message->direction === 'in') {
                event(new MessageReceived($message));
            }
        });
    }
}
