<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Template extends Model
{
    use HasFactory;

    protected $primaryKey = 'template_id';
    protected $fillable = [
        'company_id', 'template_name', 'category', 'language', 'title_type',
        'title_text', 'title_file','header_variables', 'body', 'footer', 'buttons',
        'call_to_action_button_text', 'quick_reply_messages', 'call_to_action_type',
        'visit_website_url', 'call_phone_no', 'variable1', 'variable2', 'variable3',
        'variable4', 'variable5', 'variable6', 'variable7', 'variable8', 'variable9',
        'variable10', 'wa_approval_status', 'user_id', 'status','media_id','meta_id'
    ];


    public function buttons()
    {
        return $this->hasMany(Buttons::class, 'template_id');
    }
}
