<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTemplatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('templates', function (Blueprint $table) {
            $table->id('template_id');
            $table->unsignedBigInteger('company_id');
            $table->string('template_name', 255);
            $table->enum('category', ['Marketing', 'Authentication', 'Utility']);
            $table->string('language', 50)->nullable();
            $table->enum('title_type', ['none', 'text', 'video', 'image', 'document']);
            $table->text('title_text')->nullable();
            $table->text('header_variables')->nullable();
            $table->string('title_file', 255)->nullable();
            $table->text('body')->nullable();
            $table->text('footer')->nullable();
            $table->enum('buttons', ['none', 'call_to_action', 'quick_reply']);
            $table->string('call_to_action_button_text', 255)->nullable();
            $table->text('quick_reply_messages')->nullable();
            $table->enum('call_to_action_type', ['none', 'Call Phone', 'Visit Website']);
            $table->string('visit_website_url', 255)->nullable();
            $table->string('call_phone_no', 20)->nullable();
            $table->string('variable1', 255)->nullable();
            $table->string('variable2', 255)->nullable();
            $table->string('variable3', 255)->nullable();
            $table->string('variable4', 255)->nullable();
            $table->string('variable5', 255)->nullable();
            $table->string('variable6', 255)->nullable();
            $table->string('variable7', 255)->nullable();
            $table->string('variable8', 255)->nullable();
            $table->string('variable9', 255)->nullable();
            $table->string('variable10', 255)->nullable();
            $table->enum('wa_approval_status', ['Approved', 'Pending', 'Rejected'])->default('Pending')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->timestamps(0); // created_at & updated_at with precision 0
            $table->enum('status', ['Active', 'Inactive'])->default('Active')->nullable();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('templates');
    }
}
