<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMessagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('messages', function (Blueprint $table) {
            $table->id('message_id'); // AUTO_INCREMENT by default
            $table->unsignedBigInteger('customer_id');
            $table->enum('type', ['chat', 'broadcast']);
            $table->unsignedBigInteger('broadcast_id')->nullable();
            $table->unsignedBigInteger('contact_id');
            $table->enum('direction', ['in', 'out']);
            $table->text('message')->nullable();
            $table->text('message_status')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->timestamp('created_date_time')->useCurrent();
            $table->timestamp('updated_date_time')->useCurrent()->useCurrentOnUpdate();
            $table->enum('status', ['Active', 'Inactive'])->default('Active');

            // Adding foreign key constraints if needed
            // $table->foreign('customer_id')->references('id')->on('customers')->onDelete('cascade');
            // $table->foreign('contact_id')->references('id')->on('contacts')->onDelete('cascade');
            // $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            // $table->foreign('broadcast_id')->references('id')->on('broadcasts')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('messages');
    }
}
