<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompaniesTable extends Migration
{
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->increments('company_id');
            $table->string('company_name', 255);
            $table->string('email_id', 255);
            $table->string('logo', 255)->nullable();
            $table->text('address')->nullable();
            $table->string('country_code', 5)->nullable();
            $table->string('mobile_no', 20)->nullable();
            $table->integer('user_id')->unsigned();
            $table->timestamp('created_date_time')->useCurrent();
            $table->timestamp('updated_date_time')->useCurrent()->useCurrentOnUpdate();
            $table->enum('status', ['Active', 'Inactive'])->default('Active');
        });
    }

    public function down()
    {
        Schema::dropIfExists('companies');
    }
}
