<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWhatsappAccountsTable extends Migration
{
    public function up()
    {
        Schema::create('whatsapp_accounts', function (Blueprint $table) {
            $table->increments('wa_ac_id');
            $table->integer('company_id')->unsigned();
            $table->string('phone_number', 255);
            $table->string('phone_number_id', 255);
            $table->string('business_ac_id', 255);
            $table->string('app_id', 255);
            $table->string('access_token', 255);
            $table->enum('status', ['Active', 'Inactive'])->default('Active');

            // Foreign key constraint (optional, uncomment if needed)
            // $table->foreign('company_id')->references('company_id')->on('companies')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('whatsapp_accounts');
    }
}
