<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contacts', function (Blueprint $table) {
            $table->id('contact_id'); // Primary key
            $table->unsignedBigInteger('customer_id');
            $table->string('contact_name');
            $table->string('mobile_no', 15);
            $table->unsignedBigInteger('user_id')->nullable(); // assuming it's optional
            $table->timestamp('created_date_time')->useCurrent();
            $table->timestamp('updated_date_time')->nullable()->useCurrentOnUpdate();
            $table->boolean('status')->default(true);
    });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contacts');
    }
};
