<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Broadcast extends Migration
{
    /**
     * Run the migrations.
     */
    
        public function up(): void {
            Schema::create('broadcasts', function (Blueprint $table) {
                $table->id('broadcast_id'); // Custom PK name
                $table->unsignedBigInteger('company_id');
                $table->string('broadcast_name');
                $table->unsignedBigInteger('template_id');
                $table->unsignedBigInteger('user_id');
                $table->timestamp('created_date_time')->useCurrent();
                $table->timestamp('updated_date_time')->nullable()->useCurrentOnUpdate();
                $table->string('status')->default('active');
            });
        }
    
        public function down(): void {
            Schema::dropIfExists('broadcasts');
        }

    
};
