<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

    public function up(): void
    {
        Schema::create('broadcast_contacts', function (Blueprint $table) {
            $table->id('broadcast_contacts_id'); // Custom PK name
            $table->unsignedBigInteger('broadcast_id');
            $table->unsignedBigInteger('contact_id');
            $table->unsignedBigInteger('user_id');
            $table->timestamp('created_date_time')->useCurrent();
            $table->timestamp('updated_date_time')->nullable()->useCurrentOnUpdate();
            $table->string('status')->default('active');

            // Foreign keys (optional, based on your app needs)
            $table->foreign('broadcast_id')->references('broadcast_id')->on('broadcasts')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('broadcast_contacts');
    }
};
