<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('broadcasts', function (Blueprint $table) {
            $table->increments('br_id');
            $table->string('broadcast_name');
            $table->integer('template_id')->nullable();
            $table->enum('type', ['schedule', 'non-schedule']);
            $table->date('schedule_date')->nullable();
            $table->time('schedule_time')->nullable();
            $table->enum('status', ['pending', 'cancelled', 'completed'])->default('pending');
            $table->integer('user_id');
            $table->integer('company_id');
            $table->timestamp('created_date_time')->nullable();
            $table->timestamp('update_date_time')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('broadcasts');
    }
};
