<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('broadcast_contacts', function (Blueprint $table) {
            $table->increments('bc_id');
            $table->integer('br_id')->unsigned();
            $table->string('contact_no');
            $table->integer('user_id');
            $table->integer('company_id');
            $table->enum('status', ['pending', 'sent', 'failed'])->default('pending');

            // Foreign key
            $table->foreign('br_id')
                  ->references('br_id')->on('broadcasts')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('broadcast_contacts');
    }
};
