<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\api\AuthController;
use App\Http\Controllers\TemplateController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\BroadcastController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\TemplatesnycController;
use Illuminate\Support\Facades\Broadcast;

// register the auth route for private channels
Broadcast::routes(['middleware' => ['auth:api']]);


Route::post('register', [AuthController::class, 'register']);
Route::post('login', [AuthController::class, 'login']);
Route::post('logout', [AuthController::class, 'logout']);
Route::post('/user_check', [AuthController::class, 'UserCheck']);
Route::post('/resend_otp', [AuthController::class, 'resendotp']);
Route::post('/reset_password', [AuthController::class, 'ResetPassword']);
Route::post('/reset_password_checked', [AuthController::class, 'ResetPasswordOtpChecked']);
Route::post('/update_otp_password', [AuthController::class, 'updateuserpassword']);

Route::post('templates', [TemplateController::class, 'store']);
Route::get('templates/show', [TemplateController::class, 'show']);
Route::get('templates/view/{id}', [TemplateController::class, 'view']);
Route::delete('templates/{id}', [TemplateController::class, 'delete']);

Route::get('/whatsapp/receive/{id}', [MessageController::class, 'receiveMessage']);
Route::get('/receive/{id}', [MessageController::class, 'messages']);
Route::get('/contacts', [MessageController::class, 'getContact']);
Route::post('/whatsapp/send', [MessageController::class, 'sendMessage'])->middleware('auth:api');
Route::post('/whatsapp/update-status', [MessageController::class, 'updateStatus']);
Route::get('/whatsapp/messages/{contactId}', [MessageController::class, 'getContactMessages'])->middleware('auth:api');
Route::post('/whatsapp/send-media', [MessageController::class, 'sendMediaMessage']);

Route::post('/contacts', [ContactController::class, 'store'])->middleware('auth:api');
Route::get('/contacts/list', [ContactController::class, 'show']);
Route::post('/contacts/import', [ContactController::class, 'import']);
Route::put('/contacts/{id}', [ContactController::class, 'update']);

Route::get('/broadcasts', [BroadcastController::class, 'index']);
Route::post('/broadcasts', [BroadcastController::class, 'store']);
Route::get('/broadcasts/{id}', [BroadcastController::class, 'show']);
Route::put('/broadcasts/{id}', [BroadcastController::class, 'update']);
Route::put('/broadcasts/{id}/cancel', [BroadcastController::class, 'cancel']);
Route::get('/broadcasts/{id}/contacts', [BroadcastController::class, 'contacts']);
Route::post('/broadcasts/showdate', [BroadcastController::class, 'showdate']);

Route::post('/broadcasts/add-contact', [BroadcastController::class, 'addContact']);
Route::delete('/broadcasts/delete-contact/{id}', [BroadcastController::class, 'deleteContact']);


Route::get('company/{id}', [CompanyController::class,'show']);
Route::get('company', [CompanyController::class,'show']);
// Route::put('company/{id}', [CompanyController::class,'store']); 
Route::post('company/{id}', [CompanyController::class,'update']); 

//users

Route::prefix('user')->group(function () {
    Route::get('/all/{id}', [UserController::class, 'alluser']);
    Route::post('/add', [UserController::class, 'store']);
    Route::put('{id}', [UserController::class, 'update']);
    Route::delete('{id}', [UserController::class, 'destroy']);
});
Route::get('user/{id}', [UserController::class, 'show']);


// Protected route that requires JWT token
Route::middleware('auth:api')->get('user', [AuthController::class, 'user']);


Route::middleware('auth:api')->group(function () {
    Route::post('/create-subscription', [SubscriptionController::class, 'create']);
    // Add other authenticated subscription routes as needed
});

// Route::get('/webhook', [WebhookController::class, 'verify']);     // Verification for Meta
// Route::post('/webhook', [WebhookController::class, 'receive']);   // Actual webhook receiver
Route::post('/templatesync/{id}', [TemplatesnycController::class, 'store']);






