// server.js
const express = require('express');
const http = require('http');
const cors = require('cors');
const app = express();
const PORT = process.env.PORT || 8080;

app.use(cors({ origin: "*" }));
app.use(express.json()); 

const server = http.createServer(app);
const io = require('socket.io')(server, {
  cors: { origin: "*", methods: ["GET","POST"] }
});

server.listen(PORT, () => console.log(`✅ Server running on port ${PORT}`));

io.on('connection', (socket) => {
  console.log('💬 New client connected', socket.id);

  socket.on('join-contact', (contactId) => {
    const room = `contact_${contactId}`;
    socket.join(room);
    console.log(`Socket ${socket.id} joined ${room}`);
  });

  socket.on('leave-contact', (contactId) => {
    const room = `contact_${contactId}`;
    socket.leave(room);
    console.log(`Socket ${socket.id} left ${room}`);
  });

  socket.on('disconnect', () => {
    console.log('Client disconnected', socket.id);
  });
});


app.post('/whatsapp-message', (req, res) => {
  const payload = req.body;
  if (!payload || !payload.contact_id) {
    return res.status(400).json({ error: 'Missing contact_id' });
  }

  const room = `contact_${payload.contact_id}`;

  io.to(room).emit('contact-message', payload);

  io.emit('global-whatsapp-message', payload);

  return res.json({ success: true });
});
